package edu.uky.ai.ml.nn;

import java.util.ArrayList;
import java.util.Random;

/**
 * Edges in a neural network are roughly equivalent to dendrites in a
 * biological neuron.  An edge goes from a parent neuron to a child neuron
 * and has a weight that scales the parent's value when sending it to the
 * child.
 * 
 * @author Stephen G. Ware
 */
public class Edge {

	/** The parent (sender) neuron */
	public final Neuron parent;
	
	/** The weight of the edge */
	public double weight;
	
	/** The child (receiver) neuron */
	public final Neuron child;
	
	/**
	 * Constructs a new edge in the network.  This edge will automatically be
	 * added to the parent list of the child and the child list of the parent.
	 * 
	 * @param parent the parent (sender) neuron
	 * @param random a random number generator for choosing the initial weight
	 * @param child the child (receiver) neuron
	 */
	public Edge(Neuron parent, Random random, Neuron child) {
		this.parent = parent;
		this.weight = random.nextDouble() * 2 - 1;
		this.child = child;
		((ArrayList<Edge>) parent.children).add(this);
		((ArrayList<Edge>) child.parents).add(this);
	}
}
